/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.editor;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmt.CmdValueListener;
import com.quantumdata.fmteditor.fmtwidgets.FmtNumericField;

public class UnitPair {
    private String m_name;
    private FmtNumericField m_primField;
    private FmtNumericField m_timeField;
    private CmdValue m_units;
    private CmdValue m_rate;
    private CmdValueListener m_primListener;
    private CmdValueListener m_timeListener;

    public UnitPair(String string, FmtNumericField fmtNumericField, FmtNumericField fmtNumericField2, CmdValue cmdValue, CmdValue cmdValue2) {
        this.m_primField = fmtNumericField;
        this.m_timeField = fmtNumericField2;
        this.m_units = cmdValue;
        this.m_rate = cmdValue2;
        this.m_name = string;
        fmtNumericField2.getValue().setDerived(true);
        this.m_units.addListener(new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                UnitPair.this.unitsChanged();
            }
        });
        this.m_primListener = new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                UnitPair.this.primChanged();
            }
        };
        this.m_primField.getValue().addListener(this.m_primListener);
        this.m_timeListener = new CmdValueListener(){

            public void valueChanged(CmdValue cmdValue) {
                UnitPair.this.timeChanged();
            }
        };
        this.m_timeField.getValue().addListener(this.m_timeListener);
        if (this.m_rate != null) {
            this.m_rate.addListener(new CmdValueListener(){

                public void valueChanged(CmdValue cmdValue) {
                    UnitPair.this.rateChanged();
                }
            });
        }
        this.primChanged();
    }

    public String name() {
        return this.m_name;
    }

    public FmtNumericField primaryField() {
        return this.m_primField;
    }

    public FmtNumericField timeField() {
        return this.m_timeField;
    }

    public void setPair(CmdValue cmdValue, CmdValue cmdValue2) {
        this.m_primField.getValue().removeListener(this.m_primListener);
        this.m_timeField.getValue().removeListener(this.m_timeListener);
        this.m_primField.setValue(cmdValue);
        this.m_timeField.setValue(cmdValue2);
        cmdValue.addListener(this.m_primListener);
        cmdValue2.addListener(this.m_timeListener);
    }

    private void unitsChanged() {
        boolean bl = this.m_units.getInt() == 0;
        this.m_primField.setEnabled(bl);
        this.m_timeField.setEnabled(!bl);
    }

    private void primChanged() {
        if (this.m_units.getInt() != 0) {
            return;
        }
        CmdValue cmdValue = this.m_primField.getValue();
        CmdValue cmdValue2 = this.m_timeField.getValue();
        double d = this.m_rate == null ? 1.0 / cmdValue.getDouble() : cmdValue.getDouble() / this.m_rate.getDouble();
        cmdValue2.setDouble(d);
    }

    private void timeChanged() {
        if (this.m_units.getInt() == 0) {
            return;
        }
        CmdValue cmdValue = this.m_primField.getValue();
        CmdValue cmdValue2 = this.m_timeField.getValue();
        if (this.m_rate == null) {
            cmdValue.setDouble(1.0 / cmdValue2.getDouble());
        } else {
            cmdValue.setDouble(cmdValue2.getDouble() * this.m_rate.getDouble());
        }
    }

    private void rateChanged() {
        CmdValue cmdValue = this.m_primField.getValue();
        CmdValue cmdValue2 = this.m_timeField.getValue();
        double d = cmdValue.getDouble() / this.m_rate.getDouble();
        cmdValue2.setDoubleQuite(d);
        this.m_timeField.displayValue();
    }
}

